//
//  MCSTracker.h
//  BPClientTest
//
//  Created by Michael Clark on 10-02-27.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef enum {
    kMCSServiceResolvePersonalScope = 1,
    kMCSServiceResolveLocalScope,
    kMCSServiceResolveRemoteScope,
    kMCSServiceResolveCloudType
} MCSServiceResolveScope;


@class MCSService;

@interface MCSServiceTracker : NSObject {
    NSMutableDictionary*   observers;  // keyed on service name -> array of observers
    NSMutableDictionary*   resolvers;  // keyed on service name -> array of MCSServiceResolver instances already resolving
    NSMutableDictionary*   resolved; // keyed on service name -> array of MCSService instances found thus far
}

+ (NSString*)serviceClassNameForServiceName: (NSString*)aName;
+ (NSString*)serviceCloudNameForServiceName: (NSString*)aName;
+ (NSUInteger)serviceDefaultPortForServiceName: (NSString*)aName;
+ (NSDictionary*)serviceSettingsForServiceName: (NSString*)aName;


+ (MCSServiceTracker*)defaultTracker;

- (void)addServiceObserver: (id)observer forLocalServiceNamed: (NSString*)serviceName;
- (void)addServiceObserver: (id)observer forRemoteServiceNamed: (NSString*)serviceName remoteAddress: (NSString*)address;
- (void)addServiceObserver: (id)observer forRemoteServiceNamed: (NSString*)serviceName remoteAddress: (NSString*)address cloudAccount:(NSString *)cloudAccount;
- (void)addServiceObserver: (id)observer forCloudServiceNamed: (NSString*)serviceName cloudAccount: (NSString*)account applicationUserName: (NSString*)appUserName password: (NSString*)password databaseName: (NSString*)aDatabaseName schemaVersion: (NSNumber*)aSchemaVersion;

- (void)removeServiceObserver: (id)observer;
// add matching versions as add
- (void)removeServiceObserver: (id)observer forLocalServiceNamed: (NSString*)serviceName;
- (void)removeServiceObserver: (id)observer forRemoteServiceNamed: (NSString*)serviceName;
- (void)removeServiceObserver: (id)observer forCloudServiceNamed: (NSString*)serviceName;

@end

@interface NSObject (MCSTrackerObserver)

- (void)tracker: (MCSServiceTracker*)tracker willSearchForServiceNamed: (NSString*)serviceName;
- (void)tracker: (MCSServiceTracker*)tracker didFindService: (MCSService*)service;
- (void)tracker: (MCSServiceTracker*)tracker didLoseService: (MCSService*)service;
- (void)tracker: (MCSServiceTracker*)tracker didStopSearchForServiceNamed: (NSString*)serviceName;

- (void)tracker: (MCSServiceTracker*)tracker hadError: (NSError*)error searchingForServiceNamed: (NSString*)serviceName;

@end